#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion

namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	
    
	[TestFixture]
	public class DAL_PatientSpecimen : BaseTest 
	{
		private DataTable _dtPatientSpecimen;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtPatientSpecimen = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM PatientSpecimen WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);

				this.RefreshData = false;
			}
		}

		[Test]
		public void ValidSpecimenExists_Pass()
		{
			System.Guid patientGuid = (System.Guid)this._dtPatientSpecimen.Rows[0][TABLES.PatientSpecimen.PatientGuid];

			DataTable dtTest = DAL.PatientSpecimen.ValidSpecimenExists(patientGuid);
			
			Assert.IsTrue(dtTest.Columns.Count == 2);
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.PatientSpecimen.PatientGuid));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenExpirationDate));
		}

		[Test]
		public void ValidSpecimenExists_Fail()
		{
			DataTable dtTest = DAL.PatientSpecimen.ValidSpecimenExists(System.Guid.NewGuid());	
			Assert.IsTrue(dtTest.Rows.Count == 0);
		}
	}
}

#endif
